package _Text_Book;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

/**
 *
 * @author John Rayworth
 * International School of Prague
 * jrayworth@isp.cz
 */

public class _9_Arrays {

    /*One of the things that makes computers powerful is their ability to execute 
    programs based on all sorts of conditions, so the program can do almost
    infininte varieties of things, all controlled by tons of conditional blocks.
    
    But the other maing thing that makes computers powerful is their ability to do 
    whatever to tons of things a the same time - for example, in a movie, changing
    the colors of millions of pixels many times a second. 
    
    So we need a way to work with tons of things at the same time in our code.
    And one of the structures we use for this is arrays.
    
    You can think of an array as being a container for many things of the same type.
    So we could have an array of millions of pixels (a picture), or an array of
    hundreds of thousands of sound samples (an mp3), or an array of ints, Strings,
    booleans or doubles.
    
    Having all of the elements of an array all together, and able to be moved 
    around together makes working with lots of things a lot easier.
     
    (But do keep in mind that the array is the container, rather than the things
    contained - this is a finickity point, but one that helps if you get it straight
    from the beginning.)*/
    
    
    public static void main(String[] args) throws IOException {


        //arrayBasics();
        //assigningAndAccessingValues_Basics();
        //accessingValues();
        //assigningValues();
        //examples();
        
        //the_Dont_Worry_About_The_Code_Just_Have_Fun_Part();




    }

    public static void arrayBasics() {

        //Declaring an array
        //There are two ways of declaring an array:

        int [] bracesWayArray = {1, 3, 45, 23, 35};

        //and:

        double [] newOperatorWayArray = new double[20];

        //The things that the array is made up of are called "elements".
        //The elements are numbered, starting at 0, not 1.

        //We access elements by using the array name, and the element number we
        //want to access inside square brackets.  For example:

        System.out.println(bracesWayArray[3]); //This will output 23.

        //Note that when we declare an int array the second way above, to begin
        //with all elements get a default value. For ints, it's 0.
        //So the following will output 0:

        System.out.println(newOperatorWayArray[3]);//Outputs 0

        //The length of the array is definite, and cannot be changed.
        //With the "braces" way of declaring an array, the length is simply the number
        //of elements declared between the braces.
        //And with the "new operator" way of declaring an array, the length is the number put
        //between the brackets.

        //Along with their elements, an array also has an attribute that is what 
        //its length is. This can be accessed by going theArrayName.length.

        System.out.println("The length of the first array is: " + bracesWayArray.length);
        System.out.println("The length of the second array is: " + newOperatorWayArray.length);
    }
    
    
    
    public static void assigningAndAccessingValues_Basics(){
        
        //Each element in an array is numbered, starting with the number 0.
        //You can assign or re-assign a value of any element by writing the array name, and 
        //the brackets with one of the element numbers inbetween.
        
        int[] newOperatorWayArray = new int[3];
        
        newOperatorWayArray[0] = 97;
        newOperatorWayArray[1] = 8754;
        newOperatorWayArray[2] = 34343498;
        
        //And so now we could access element # 2, for example, the following way:
        
        System.out.println(newOperatorWayArray[2]);
        
    }
    
    
    
    
    
    public static void accessingValues(){
        
        //Since arrays are of a definite length, and because each of the elements
        //is numbered (starting with 0), it's easy to access all the elements by
        //using a for loop - you just use the loop control variable as the element 
        //number. For example:
        
        int[] bracesWayArray = {1, 3, 45, 23, 35};
        
        for(int i = 0; i < bracesWayArray.length; i++){
            System.out.println(bracesWayArray[i]);
        }                                                               //Outputs 1, 3, 45, 23, and 35 each on their own line.
        
        //or exactly the same for an array made the other way.
        
        int[] newOperatorWayArray = new int[20];
        
        for(int i = 0; i < newOperatorWayArray.length; i++){
            System.out.println(newOperatorWayArray[i]);
        }                                                               //Outputs 0 twenty times on twenty lines.
        
        

    }
    
    
    
    
    
    
    
    
    
    
    
    public static void assigningValues_2(){
        
        //If you declare an array the "new operator" way, you need to assign values.
        //As seen above, you could do that one at a time, like:
        
        
        int[] newOperatorWayArray = new int[20];
        
        newOperatorWayArray[0] = 9797;
        newOperatorWayArray[1] = 8754;
        newOperatorWayArray[2] = 89898;
        //etc.
        
        
        //But an easier way could be to use a for loop, just like with accessing elements, 
        //like:
        
        for(int i = 3; i < newOperatorWayArray.length; i++){
            newOperatorWayArray[i] = 999;//Assigns all elements 999.
        }     
        
        
        for(int i = 0; i < newOperatorWayArray.length; i++){
            System.out.println(newOperatorWayArray[i]);
        }
        
    }
    
    
    
    
    
    
    
    public static void examples() throws IOException{
        
        
        
        System.out.println("Random Double Example");
        
        double [] doubleArray = new double[10];
        for(int i = 0; i < doubleArray.length; i++){
            doubleArray[i] = Math.floor(Math.random()*100);//Assigns random real numbers between 0 and 100.
        }
        
        for(int i = 0; i < doubleArray.length; i++){
            System.out.println(doubleArray[i]);
        }
        
        
        
        
        
        
        
        
        System.out.println("User Input of Strings Example");
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        
        String [] stringArray = new String[4];
        for(int i = 0; i < stringArray.length; i++){
            System.out.println("What's the next String you would like to add to the array?");
            stringArray[i] = br.readLine();
        }
        
        System.out.println("The Strings you added to the array are:");
        for(int i = 0; i < stringArray.length; i++){
            System.out.println(stringArray[i]);
        }
        
    }
    
    
}
